/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - is Visible / is Invisible (Property)")
@Description(value={"Gets whether the item frame is visible or not.\nCan be set."})
@Examples(value={"set item frame is visible property of {_itemFrame} to true", "broadcast item frame is visible property of target"})
@Since(value={"1.3"})
public class ExprItemFrameIsVisible
extends SimpleBooleanPropertyExpression<Entity> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("in");
    }

    @Override
    public void set(Entity from, Boolean to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            itemFrame.setInvisible(to.booleanValue());
        }
    }

    @Override
    public void reset(Entity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(Entity from) {
        ItemFrame itemFrame;
        return from instanceof ItemFrame && (itemFrame = (ItemFrame)from).isVisible() ^ this.isNegated();
    }

    protected String getPropertyName() {
        return "item frame is " + (this.isNegated() ? "in" : "") + "visible property";
    }

    static {
        ExprItemFrameIsVisible.register(ExprItemFrameIsVisible.class, Boolean.class, "item[ |-]frame", "[is] [:in]visible", "entities");
    }
}

