/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.llama.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.jetbrains.annotations.NotNull;

@Name(value="Llama - Has Caravan Tail")
@Description(value={"Checks if another llama is currently following behind this llama."})
@Examples(value={"on damage:\n\tif victim has a caravan tail:\n\t\tbroadcast \"the caravan is being disturbed!!\""})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class CondLlamaHasCaravanTail
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity e) {
        Llama llama;
        return e instanceof Llama && (llama = (Llama)e).hasCaravanTail();
    }

    @NotNull
    protected String getPropertyName() {
        return "a caravan tail";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            CondLlamaHasCaravanTail.register(CondLlamaHasCaravanTail.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"[a] caravan tail", (String)"livingentities");
        }
    }
}

