/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.llama.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Llama - Leave Caravan")
@Description(value={"Makes a llama leave its caravan."})
@Examples(value={"make target leave its caravan"})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class EffLlamaLeaveCaravan
extends Effect {
    private Expression<LivingEntity> entityExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entityExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.entityExpression.toString(event, debug) + "leave caravan";
    }

    protected void execute(@NotNull Event event) {
        LivingEntity[] entities;
        for (LivingEntity entity : entities = (LivingEntity[])this.entityExpression.getArray(event)) {
            if (!(entity instanceof Llama)) continue;
            Llama llama = (Llama)entity;
            llama.leaveCaravan();
        }
    }

    static {
        if (Constants.PAPER_1_19_2) {
            Skript.registerEffect(EffLlamaLeaveCaravan.class, (String[])new String[]{"make %livingentities% leave [its|the[ir]] caravan"});
        }
    }
}

