/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.llama.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.jetbrains.annotations.NotNull;

@Name(value="Llama - Caravan Head")
@Description(value={"Returns the caravan head of a llama."})
@Examples(value={"broadcast caravan head of target"})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class ExprLlamaCaravanHead
extends SimplePropertyExpression<LivingEntity, LivingEntity> {
    @NotNull
    public Class<? extends LivingEntity> getReturnType() {
        return LivingEntity.class;
    }

    public LivingEntity convert(LivingEntity e) {
        if (e instanceof Llama) {
            Llama llama = (Llama)e;
            return llama.getCaravanHead();
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "llama caravan head";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            ExprLlamaCaravanHead.register(ExprLlamaCaravanHead.class, LivingEntity.class, (String)"[llama] caravan head", (String)"livingentities");
        }
    }
}

