/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.llama.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.LuskMath;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.jetbrains.annotations.Nullable;

@Name(value="Llama - Strength")
@Description(value={"Returns the provided llamas' strength.\nA higher strength llama will have more inventory slots and be more threatening to entities.\n\nCan be set.\n\nMust be between 1 and 5."})
@Examples(value={"broadcast strength of target"})
@Since(value={"1.0.3, 1.3 (Plural)"})
public class ExprLlamaStrength
extends SimplerPropertyExpression<LivingEntity, Integer> {
    @Nullable
    public Integer convert(LivingEntity from) {
        Integer n;
        if (from instanceof Llama) {
            Llama llama = (Llama)from;
            n = llama.getStrength();
        } else {
            n = null;
        }
        return n;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Integer to) {
        if (from instanceof Llama) {
            Llama llama = (Llama)from;
            llama.setStrength(LuskMath.fit(1, to, 5));
        }
    }

    @Override
    public void add(LivingEntity from, Integer to) {
        if (from instanceof Llama) {
            Llama llama = (Llama)from;
            llama.setStrength(LuskMath.fit(1, llama.getStrength() + to, 5));
        }
    }

    @Override
    public void remove(LivingEntity from, Integer to) {
        if (from instanceof Llama) {
            Llama llama = (Llama)from;
            llama.setStrength(LuskMath.fit(1, llama.getStrength() - to, 5));
        }
    }

    protected String getPropertyName() {
        return "llama strength";
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    static {
        ExprLlamaStrength.register(ExprLlamaStrength.class, Integer.class, (String)"llama strength", (String)"livingentities");
    }
}

