/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.ocelot.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.jetbrains.annotations.NotNull;

@Name(value="Ocelot - is Trusting")
@Description(value={"Checks if an ocelot trusts players."})
@Examples(value={"on damage of ocelot:\n\tif victim is trusting:\n\t\tcancel event\n\t\tbroadcast \"Don't betray %victim%!\""})
@Since(value={"1.0.2"})
public class CondOcelotTrusting
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Ocelot ocelot;
        return entity instanceof Ocelot && (ocelot = (Ocelot)entity).isTrusting();
    }

    @NotNull
    protected String getPropertyName() {
        return "trusting";
    }

    static {
        CondOcelotTrusting.register(CondOcelotTrusting.class, (String)"trusting", (String)"livingentities");
    }
}

