/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Dropped Item - Will Fly at Player")
@Description(value={"Checks whether or not the dropped item in the Pickup Attempt Event will fly at the player."})
@Examples(value={""})
@Since(value={"1.0.4"})
public class CondDroppedItemWillFlyAtPlayer
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(PlayerAttemptPickupItemEvent.class)) {
            Skript.error((String)"This condition can only be used in the Pickup Attempt Event!");
            return false;
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the dropped item will " + (this.isNegated() ? "not" : "") + " fly at player";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((PlayerAttemptPickupItemEvent)event).getFlyAtPlayer();
    }

    static {
        Skript.registerCondition(CondDroppedItemWillFlyAtPlayer.class, (String[])new String[]{"[the] [dropped] item will fly (towards|at) [the] player", "[the] [dropped] item w(ill no|on')t fly (towards|at) [the] player"});
    }
}

