/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.PlayerUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Name(value="Player - is Crawling")
@Description(value={"Checks if a player is crawling."})
@Examples(value={"on damage of player:\n\tif victim is crawling:\n\t\tif chance of 0.5:\n\t\t\tcancel event\n\t\t\tsend \"Your attack has failed!\" to attacker"})
@Since(value={"1.0.0, 1.3 (Plural)"})
public class CondPlayerCrawling
extends PropertyCondition<Player> {
    public boolean check(Player player) {
        return PlayerUtils.isCrawling(player);
    }

    @NotNull
    protected String getPropertyName() {
        return "crawling";
    }

    static {
        CondPlayerCrawling.register(CondPlayerCrawling.class, (String)"crawling", (String)"players");
    }
}

