/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Should Trigger Advancements")
@Description(value={"This Condition requires Paper.\n\nChecks whether or not the Slot Change event should trigger advancements."})
@Examples(value={"on item obtain:\n  if the event will trigger any advancements:\n    make the event not trigger any advancements\n"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class CondTriggerAdvancements
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(PlayerInventorySlotChangeEvent.class)) {
            Skript.error((String)"This condition can only be used in the Slot Change event!");
            return false;
        }
        if (matchedPattern == 1) {
            this.setNegated(true);
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the event will " + (this.isNegated() ? "not" : "") + " trigger any advancements";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((PlayerInventorySlotChangeEvent)event).shouldTriggerAdvancements();
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerInventorySlotChangeEvent")) {
            Skript.registerCondition(CondTriggerAdvancements.class, (String[])new String[]{"[the] event will trigger [any] advancements", "[the] event w(ill not|on't) trigger [any] advancements"});
        }
    }
}

