/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Will Be Damaged")
@Description(value={"This Condition requires Paper.\n\nChecks whether or not the entity in the Pre Damage Event will be damaged."})
@Examples(value={""})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class CondWillBeDamaged
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(PrePlayerAttackEntityEvent.class)) {
            Skript.error((String)"This condition can only be used in the Pre Damage event!");
            return false;
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the entity " + (this.isNegated() ? "will not" : "will") + " be damaged";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((PrePlayerAttackEntityEvent)event).willAttack();
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PrePlayerAttackEntityEvent")) {
            Skript.registerCondition(CondWillBeDamaged.class, (String[])new String[]{"[the] entity will be (damaged|attacked)", "[the] entity w(ill not|on't) be (damaged|attacked)"});
        }
    }
}

