/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.LuskUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Player - Fake Experience")
@Description(value={"Send an experience change. This fakes an experience change packet for a user. This will not actually change the experience points in any way.\nProgress must be within 0 and 1."})
@Examples(value={"show xp level 12 and progress 0.5 to all players"})
@Since(value={"1.0.2, 1.1 (decimal xp)"})
@DocumentationId(value="9046")
public class EffPlayerFakeExperience
extends Effect {
    private Expression<Integer> levelExpression;
    private Expression<Number> progressExpression;
    private Expression<Player> playerExpression;
    private int pattern;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.pattern = matchedPattern;
        if (this.pattern == 2) {
            this.progressExpression = expressions[0];
            this.playerExpression = expressions[1];
        } else if (this.pattern == 1) {
            this.levelExpression = expressions[0];
            this.playerExpression = expressions[1];
        } else {
            this.levelExpression = expressions[0];
            this.progressExpression = expressions[1];
            this.playerExpression = expressions[2];
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        Float xp = null;
        Integer lvl = null;
        if (this.pattern == 0 || this.pattern == 2) {
            Number progressNumber = (Number)this.progressExpression.getSingle(event);
            if (progressNumber == null) {
                return;
            }
            xp = Float.valueOf(progressNumber.floatValue());
            xp = Float.valueOf(Math.max(Math.min(xp.floatValue(), 1.0f), 0.0f));
        }
        if (this.pattern == 0 || this.pattern == 1) {
            lvl = (Integer)this.levelExpression.getSingle(event);
            if (lvl == null) {
                return;
            }
            lvl = Math.max(lvl, 0);
        }
        for (Player player : (Player[])this.playerExpression.getArray(event)) {
            if (this.pattern == 2 && xp != null) {
                player.sendExperienceChange(xp.floatValue());
                continue;
            }
            if (this.pattern == 1 && lvl != null) {
                long calcNext = LuskUtils.getTotalNeededXP(player.getLevel() + 1);
                long calcCurrent = LuskUtils.getTotalNeededXP(player.getLevel());
                long calcFull = calcNext - calcCurrent;
                xp = Float.valueOf(((long)player.getTotalExperience() - calcCurrent) / calcFull);
                player.sendExperienceChange(xp.floatValue(), lvl.intValue());
                continue;
            }
            if (lvl == null || xp == null) continue;
            player.sendExperienceChange(xp.floatValue(), lvl.intValue());
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String progress = this.progressExpression.toString(event, debug);
        String player = this.playerExpression.toString(event, debug);
        String level = this.levelExpression.toString(event, debug);
        StringBuilder string = new StringBuilder("show fake experience");
        if (this.pattern == 0) {
            string.append("level ").append(level).append(" and progress ").append(progress);
        } else if (this.pattern == 1) {
            string.append("level ").append(level);
        } else {
            string.append("progress ").append(progress);
        }
        string.append(" to ").append(player);
        return string.toString();
    }

    static {
        Skript.registerEffect(EffPlayerFakeExperience.class, (String[])new String[]{"show [fake] [e]xp[erience] level %integer% and progress %number% to %players%", "show [fake] [e]xp[erience] level %integer% to %players%", "show [fake] [e]xp[erience] progress %number% to %players%"});
    }
}

