/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.ItemUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Player - Start/Stop Riptiding")
@Description(value={"Makes a player riptide. (also known as spin attack)\n\nStopping makes the player riptide for a tick, which stops it a tick later.\n\nThe duration must be greater than or equal to 1 tick.\nAttack strength will default to 0\n\n`if player is riptiding:` will return true for the given duration.\n\n"})
@Examples(value={"make player riptide for 2 seconds with attack strength 4", "make player stop riptiding"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.21.1"})
public class EffPlayerRiptide
extends Effect {
    private Expression<Player> playerExpression;
    private Expression<Timespan> timespanExpression = null;
    private Expression<ItemType> itemTypeExpression = null;
    private Expression<Number> numberExpression = null;
    private boolean stop;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.playerExpression = expressions[0];
        boolean bl = this.stop = matchedPattern == 1;
        if (!this.stop) {
            this.timespanExpression = expressions[1];
            this.itemTypeExpression = expressions[2];
            this.numberExpression = expressions[3];
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder builder = new StringBuilder("make ").append(this.playerExpression.toString(event, debug));
        if (this.stop) {
            return builder.append(" stop riptiding").toString();
        }
        builder.append(" start riptiding for ");
        if (this.timespanExpression != null) {
            builder.append(this.timespanExpression.toString(event, debug));
        }
        if (this.itemTypeExpression != null) {
            builder.append(" using ").append(this.itemTypeExpression.toString(event, debug));
        }
        if (this.numberExpression != null) {
            builder.append(" with attack damage ").append(this.numberExpression.toString(event, debug));
        }
        return builder.toString();
    }

    protected void execute(@NotNull Event event) {
        int duration;
        float attackStrength;
        ItemStack attackItem;
        if (this.stop) {
            attackItem = null;
            attackStrength = 0.0f;
            duration = 1;
        } else {
            Timespan timespan = (Timespan)this.timespanExpression.getSingle(event);
            if (timespan == null) {
                return;
            }
            duration = (int)CompatibilityUtils.getTicks(timespan);
            if (duration < 1) {
                return;
            }
            attackStrength = this.numberExpression == null ? 0.0f : Math.max(((Number)this.numberExpression.getOptionalSingle(event).orElse(0)).floatValue(), 0.0f);
            attackItem = ItemUtils.getSingleItemTypeToItemStack(this.itemTypeExpression, event);
        }
        for (Player player : (Player[])this.playerExpression.getAll(event)) {
            if (this.stop && !player.isRiptiding()) continue;
            player.startRiptideAttack(duration, attackStrength, attackItem);
        }
    }

    static {
        if (Constants.HAS_START_RIPTIDE_ATTACK) {
            Skript.registerEffect(EffPlayerRiptide.class, (String[])new String[]{"make %players% (start riptiding|riptide|spin attack) for %timespan% [using %-itemtype%] [with [attack] (strength|damage) %-number%]", "make %players% (stop|finish) (riptiding|spin attacking)"});
        }
    }
}

