/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Player - Sleep")
@Description(value={"Attempts to, or forces one or more players to sleep in a bed.\nAttempting will fail under vanilla conditions in which the player cannot sleep, ex: Daytime, too far away, etc"})
@Examples(value={"try to make player sleep at {_bed} # not forced\nforcefully make player sleep at {_bed} # forced"})
@Since(value={"1.3"})
public class EffPlayerSleep
extends Effect {
    private Expression<Player> playersExpression;
    private Expression<Location> locationExpression;
    private boolean force;

    protected void execute(Event event) {
        Location location = (Location)this.locationExpression.getSingle(event);
        if (location != null) {
            this.playersExpression.stream(event).forEach(player -> player.sleep(location, this.force));
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return (this.force ? "forcefully" : "attempt to") + " make " + this.playersExpression.toString(event, b) + " sleep at " + this.locationExpression.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.playersExpression = expressions[0];
        this.locationExpression = expressions[1];
        this.force = i == 0 ? !parseResult.hasTag("attempt") : i == 2;
        return true;
    }

    static {
        Skript.registerEffect(EffPlayerSleep.class, (String[])new String[]{"(forcefully|attempt:(try|attempt) to) make %players% sleep at %location%", "try making %players% sleep at %location%", "force %players% to sleep at %location%"});
    }
}

