/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.util.slot.CursorSlot;
import ch.njol.skript.util.slot.DroppedItemSlot;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import it.jakegblp.lusk.api.events.PlayerInventorySlotDropEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class EvtPlayerEvents {
    static {
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerChangedMainHandEvent")) {
            Skript.registerEvent((String)"Player - on Main Hand Change", SimpleEvent.class, PlayerChangedMainHandEvent.class, (String[])new String[]{"main hand switch[ed|ing]"}).description(new String[]{"Called when a player changes their main hand in the client settings."}).examples(new String[]{""}).since("1.0.0");
        }
        Skript.registerEvent((String)"Player - on Velocity Change", SimpleEvent.class, PlayerVelocityEvent.class, (String[])new String[]{"player velocity [chang(e[d]|ing)]"}).description(new String[]{"Called when the velocity of a player changes due to outside circumstances."}).examples(new String[]{"on player velocity change:"}).since("1.3");
        CompatibilityUtils.registerEventValue(PlayerVelocityEvent.class, Vector.class, PlayerVelocityEvent::getVelocity, 0);
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerBedFailEnterEvent")) {
            Skript.registerEvent((String)"Player - on Sleep Fail", SimpleEvent.class, PlayerBedFailEnterEvent.class, (String[])new String[]{"(sleep|bed [enter]) [attempt] fail", "fail[ed] to (sleep|enter [the] bed)"}).description(new String[]{"Called when a player attempts to sleep but fails.."}).examples(new String[]{""}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PlayerBedFailEnterEvent.class, Block.class, PlayerBedFailEnterEvent::getBed, 0);
            CompatibilityUtils.registerEventValue(PlayerBedFailEnterEvent.class, Location.class, e -> e.getBed().getLocation(), 0);
        }
        if (Skript.classExists((String)"io.papermc.paper.event.player.PrePlayerAttackEntityEvent")) {
            Skript.registerEvent((String)"Player - on Pre Damage", SimpleEvent.class, PrePlayerAttackEntityEvent.class, (String[])new String[]{"pre[-| ]damage"}).description(new String[]{"Called when the player tries to attack an entity. This occurs before any of the damage logic, so cancelling this event will prevent any sort of sounds from being played when attacking. This event will fire as cancelled for certain entities, use the \"will be damaged\" condition to check if the entity will not actually be attacked.\nNote: there may be other factors (invulnerability, etc) that will prevent this entity from being attacked that this event will not cover."}).examples(new String[]{""}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PrePlayerAttackEntityEvent.class, Entity.class, PrePlayerAttackEntityEvent::getAttacked, 0);
        }
        if (Skript.classExists((String)"com.destroystokyo.paper.event.player.PlayerPostRespawnEvent")) {
            Skript.registerEvent((String)"Player - on Post-Respawn", SimpleEvent.class, PlayerPostRespawnEvent.class, (String[])new String[]{"post[-| ]respawn"}).description(new String[]{"Fired after a player has respawned."}).examples(new String[]{""}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PlayerPostRespawnEvent.class, Location.class, PlayerPostRespawnEvent::getRespawnedLocation, 0);
        }
        if (Skript.classExists((String)"com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent")) {
            Skript.registerEvent((String)"Whitelist - on Player Profile Verify", SimpleEvent.class, ProfileWhitelistVerifyEvent.class, (String[])new String[]{"[player] [profile] whitelist verify"}).description(new String[]{"Fires when the server needs to verify if a player is whitelisted. Plugins may override/control the servers whitelist with this event, and dynamically change the kick message."}).examples(new String[]{""}).since("1.0.2").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(ProfileWhitelistVerifyEvent.class, OfflinePlayer.class, e -> {
                UUID id = e.getPlayerProfile().getId();
                if (id != null) {
                    return Bukkit.getOfflinePlayer((UUID)id);
                }
                return null;
            }, 0);
        }
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerAttemptPickupItemEvent")) {
            Skript.registerEvent((String)"Player - on Pickup Attempt", SimpleEvent.class, PlayerAttemptPickupItemEvent.class, (String[])new String[]{"[player] pickup attempt", "[player] attempt to pickup"}).description(new String[]{"Called when a player attempts to pick an item up from the ground."}).examples(new String[]{""}).since("1.0.4");
        }
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerHarvestBlockEvent")) {
            Skript.registerEvent((String)"Player - on Block Harvest", SimpleEvent.class, PlayerHarvestBlockEvent.class, (String[])new String[]{"[block] harvest"}).description(new String[]{"This event is called whenever a player harvests a block.\nA 'harvest' is when a block drops an item (usually some sort of crop) and changes state, but is not broken in order to drop the item.\nThis event is not called for when a block is broken."}).examples(new String[]{""}).since("1.1.1");
            CompatibilityUtils.registerEventValue(PlayerHarvestBlockEvent.class, Block.class, PlayerHarvestBlockEvent::getHarvestedBlock, 0);
            CompatibilityUtils.registerEventValue(PlayerHarvestBlockEvent.class, ItemStack[].class, e -> e.getItemsHarvested().toArray(new ItemStack[0]), 0);
        }
        Skript.registerEvent((String)"Player - on Inventory Slot Drop", SimpleEvent.class, PlayerInventorySlotDropEvent.class, (String[])new String[]{"player slot drop"}).description(new String[]{"Called when a player drops an item from an inventory (or their own).\n"}).examples(new String[]{""}).since("1.3");
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, Slot.class, e -> {
            if (e.getSlot() >= 36) {
                return new EquipmentSlot((HumanEntity)e.getPlayer(), e.getSlot());
            }
            if (e.isDropsFromCursor()) {
                return new CursorSlot(e.getPlayer(), e.getItem());
            }
            return new InventorySlot(e.getInventory(), e.getSlot());
        }, -1);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, Slot.class, e -> new DroppedItemSlot(e.getItemEntity()), 0);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, Item.class, PlayerInventorySlotDropEvent::getItemEntity, 0);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, ItemStack.class, PlayerInventorySlotDropEvent::getOriginalItem, -1);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, ItemStack.class, PlayerInventorySlotDropEvent::getItem, 0);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, Inventory.class, PlayerInventorySlotDropEvent::getInventory, 0);
        CompatibilityUtils.registerEventValue(PlayerInventorySlotDropEvent.class, Integer.class, PlayerInventorySlotDropEvent::getSlot, 0);
    }
}

