/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Name(value="Player - Player Tab List Order")
@Description(value={"Returns the relative order that the player is shown on the player list.\nCan be set, added to and removed from.\n\nSetting this modifies the order for the player you're setting it for."})
@Examples(value={"broadcast tab list order of player"})
@Since(value={"1.3.9"})
@RequiredPlugins(value={"1.21.2"})
public class ExprPlayerTabListOrder
extends SimplerPropertyExpression<Player, Integer> {
    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public Integer convert(Player player) {
        return player.getPlayerListOrder();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public void set(Player from, Integer to) {
        from.setPlayerListOrder(to.intValue());
    }

    @Override
    public void add(Player from, Integer to) {
        from.setPlayerListOrder(from.getPlayerListOrder() + to);
    }

    @Override
    public void remove(Player from, Integer to) {
        this.add(from, -to.intValue());
    }

    @NotNull
    protected String getPropertyName() {
        return "tab list order";
    }

    static {
        if (Constants.MINECRAFT_1_21_2) {
            ExprPlayerTabListOrder.register(ExprPlayerTabListOrder.class, Integer.class, (String)"((tab[ ]|player )list|tab) order", (String)"players");
        }
    }
}

