/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.skeletonhorse.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SkeletonHorse;
import org.jetbrains.annotations.NotNull;

@Name(value="Skeleton Horse - is Trapped")
@Description(value={"Checks if a skeleton horse is trapped."})
@Examples(value={"on damage of skeleton horse:\n\tif victim is trapped:\n\t\tcancel event"})
@Since(value={"1.0.3"})
public class CondSkeletonHorseTrapped
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        SkeletonHorse skeletonHorse;
        return entity instanceof SkeletonHorse && (skeletonHorse = (SkeletonHorse)entity).isTrapped();
    }

    @NotNull
    protected String getPropertyName() {
        return "trapped";
    }

    static {
        CondSkeletonHorseTrapped.register(CondSkeletonHorseTrapped.class, (String)"trapped", (String)"livingentities");
    }
}

