/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.trident.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.LuskMath;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Trident - Loyalty")
@Description(value={"Returns loyalty level of a thrown trident.\n\nAllows: Setting, Removing, Adding, Deleting and Resetting.\n\nThis value will always be between 0 and 127.\n\nChanging this value won't influence the item itself, just the throw trident."})
@Examples(value={"broadcast loyalty of {_trident}"})
@Since(value={"1.2"})
public class ExprTridentLoyalty
extends SimpleExpression<Integer> {
    private Expression<Projectile> projectileExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.projectileExpression = exprs[0];
        return true;
    }

    protected Integer @NotNull [] get(@NotNull Event e) {
        Projectile projectile = (Projectile)this.projectileExpression.getSingle(e);
        if (projectile instanceof Trident) {
            Trident trident = (Trident)projectile;
            return new Integer[]{trident.getLoyaltyLevel()};
        }
        return new Integer[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: 
            case REMOVE: 
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Integer.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return;
        }
        Object object = this.projectileExpression.getSingle(e);
        if (object instanceof Trident) {
            Trident trident = (Trident)object;
            if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                trident.setLoyaltyLevel(0);
            } else {
                Object object2 = delta[0];
                if (object2 instanceof Integer) {
                    Integer integer = (Integer)object2;
                    if (mode == Changer.ChangeMode.ADD) {
                        integer = trident.getLoyaltyLevel() + integer;
                    } else if (mode == Changer.ChangeMode.REMOVE) {
                        integer = trident.getLoyaltyLevel() - integer;
                    }
                    trident.setLoyaltyLevel(LuskMath.fit(0, integer, 127));
                }
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the trident loyalty level of " + this.projectileExpression.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprTridentLoyalty.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [trident] loyalty [level] of %projectile%", "%projectile%'[s] [trident] loyalty [level]"});
    }
}

