/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;

@Name(value="Warden - is Calm")
@Description(value={"Checks if a Warden is calm."})
@Examples(value={"on damage of warden:\n\tif victim is calm:\n\t\tbroadcast \"You're making a big mistake...\""})
@Since(value={"1.0.2"})
public class CondWardenCalm
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Warden warden;
        return entity instanceof Warden && (warden = (Warden)entity).getAngerLevel() == Warden.AngerLevel.CALM;
    }

    @NotNull
    protected String getPropertyName() {
        return "calm";
    }

    static {
        CondWardenCalm.register(CondWardenCalm.class, (String)"calm", (String)"livingentities");
    }
}

