/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Warden - Disturb")
@Description(value={"Makes a warden sense a disturbance at the provided location."})
@Examples(value={"disturb {_warden} from {_location}\n"})
@Since(value={"1.0.2"})
public class EffWardenDisturbance
extends Effect {
    private Expression<LivingEntity> entitiesExpression;
    private Expression<Location> locationExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entitiesExpression = expressions[0];
        this.locationExpression = expressions[1];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "disturb " + this.entitiesExpression.toString(event, debug) + " from " + this.locationExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        Location location = (Location)this.locationExpression.getSingle(event);
        if (location == null) {
            return;
        }
        for (LivingEntity entity : (LivingEntity[])this.entitiesExpression.getArray(event)) {
            if (!(entity instanceof Warden)) continue;
            Warden warden = (Warden)entity;
            warden.setDisturbanceLocation(location);
        }
    }

    static {
        Skript.registerEffect(EffWardenDisturbance.class, (String[])new String[]{"disturb %livingentities% from %location%"});
    }
}

