/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Warden - Anger")
@Description(value={"Returns the anger of a warden.\n\nAngry = 80 or above\nAgitated = 40-79\nCalm = 0-39\n\nUse the respective conditions to check for those 3 states."})
@Examples(value={"broadcast anger of target"})
@Since(value={"1.0.2"})
public class ExprWardenAnger
extends SimplePropertyExpression<Entity, Integer> {
    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Integer convert(Entity e) {
        if (e instanceof Warden) {
            Warden warden = (Warden)e;
            return warden.getAnger();
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "anger";
    }

    static {
        ExprWardenAnger.register(ExprWardenAnger.class, Integer.class, (String)"anger", (String)"entity");
    }
}

