/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Warden Anger (Event)")
@Description(value={"Returns the past/future anger of the warden in the Warden Anger Change event.\nThe future anger level can be set."})
@Examples(value={""})
@Since(value={"1.0.1"})
@RequiredPlugins(value={"Paper"})
public class ExprWardenEventAnger
extends SimpleExpression<Integer> {
    private boolean past;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(WardenAngerChangeEvent.class)) {
            Skript.error((String)"This expression can only be used in the Warden Anger Change Event!");
            return false;
        }
        this.past = parseResult.hasTag("past");
        return true;
    }

    protected Integer @NotNull [] get(@NotNull Event e) {
        int i = this.past ? ((WardenAngerChangeEvent)e).getOldAnger() : ((WardenAngerChangeEvent)e).getNewAnger();
        return new Integer[]{i};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Integer.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            ((WardenAngerChangeEvent)e).setNewAnger(integer.intValue());
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the" + (this.past ? " past" : " future") + " anger level of the warden";
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.entity.WardenAngerChangeEvent")) {
            Skript.registerExpression(ExprWardenEventAnger.class, Integer.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] [future|:past] anger [level] [of [the] warden]"});
        }
    }
}

