/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Warden - Prey")
@Description(value={"Returns the entity at which this warden is most angry."})
@Examples(value={"broadcast prey of target"})
@Since(value={"1.0.2"})
public class ExprWardenPrey
extends SimplePropertyExpression<Entity, LivingEntity> {
    @NotNull
    public Class<? extends LivingEntity> getReturnType() {
        return LivingEntity.class;
    }

    @Nullable
    public LivingEntity convert(Entity e) {
        if (e instanceof Warden) {
            Warden warden = (Warden)e;
            return warden.getEntityAngryAt();
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "prey";
    }

    static {
        ExprWardenPrey.register(ExprWardenPrey.class, LivingEntity.class, (String)"prey", (String)"entity");
    }
}

