/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entitysnapshot.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.EntitySnapshot;

@Name(value="Entity Snapshot - As String")
@Description(value={"Gets the String NBT of the provided entity snapshots."})
@Examples(value={"send entity snapshot string nbt of {_entitySnapshot}"})
@Since(value={"1.3.3"})
@RequiredPlugins(value={"1.20.5+"})
public class ExprEntitySnapshotAsString
extends SimplePropertyExpression<EntitySnapshot, String> {
    public String convert(EntitySnapshot entitySnapshot) {
        return entitySnapshot.getAsString();
    }

    protected String getPropertyName() {
        return "entity snapshot nbt string";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        if (Constants.HAS_ENTITY_SNAPSHOT_GET_AS_STRING) {
            ExprEntitySnapshotAsString.register(ExprEntitySnapshotAsString.class, String.class, (String)"entity[ |-]snapshot (nbt string|string nbt)", (String)"entitysnapshots");
        }
    }
}

