/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entitysnapshot.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Snapshot - From String")
@Description(value={"Attempts to create an entity snapshots from a previously created string nbt of one."})
@Examples(value={"send entity snapshot of string nbt {_stringNBT}"})
@Since(value={"1.3.3"})
@RequiredPlugins(value={"1.20.5+"})
public class ExprEntitySnapshotFromString
extends SimplePropertyExpression<String, EntitySnapshot> {
    @Nullable
    public EntitySnapshot convert(String s) {
        try {
            return Bukkit.getEntityFactory().createEntitySnapshot(s);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    protected String getPropertyName() {
        return null;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "entity snapshots of string nbt " + this.getExpr().toString(event, debug);
    }

    public Class<? extends EntitySnapshot> getReturnType() {
        return EntitySnapshot.class;
    }

    static {
        if (Constants.HAS_ENTITY_SNAPSHOT_GET_AS_STRING) {
            Skript.registerExpression(ExprEntitySnapshotFromString.class, EntitySnapshot.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"entity[ |-]snapshot[s] (of|from|using) (nbt string|string nbt) %strings%"});
        }
    }
}

