/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entitysnapshot.types;

import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import it.jakegblp.lusk.utils.Constants;
import java.io.StreamCorruptedException;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySnapshotClassInfos {
    static {
        if (Constants.HAS_ENTITY_SNAPSHOT && Classes.getExactClassInfo(EntitySnapshot.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(EntitySnapshot.class, "entitysnapshot").user(new String[]{"entity ?snapshots?"}).name("Entity Snapshot").description(new String[]{"Represents an immutable copy of an entity's state. Can be used at any time to create an instance of the stored entity.\n\nRequires 1.20.5 to be stored and parsed.\n**This will NOT work when using Skript 2.10+**\n"}).since("1.3").requiredPlugins(new String[]{"1.20.2+, 1.20.5+ (for storing)"}).parser((Parser)new Parser<EntitySnapshot>(){

                @Nullable
                public EntitySnapshot parse(@NotNull String s, @NotNull ParseContext context) {
                    try {
                        return Bukkit.getEntityFactory().createEntitySnapshot(s);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return null;
                    }
                }

                public boolean canParse(@NotNull ParseContext context) {
                    return Constants.HAS_ENTITY_SNAPSHOT_GET_AS_STRING;
                }

                @NotNull
                public String toString(EntitySnapshot s, int flags) {
                    return "entity snapshot of type " + String.valueOf(EntityUtils.toSkriptEntityData((EntityType)s.getEntityType()));
                }

                @NotNull
                public String toVariableNameString(EntitySnapshot s) {
                    return s.getAsString();
                }

                @NotNull
                public String getDebugMessage(EntitySnapshot s) {
                    return this.toString(s, 0) + " entity snapshot (" + String.valueOf(s) + ")";
                }
            }).serializer((Serializer)new Serializer<EntitySnapshot>(){

                public Fields serialize(EntitySnapshot o) {
                    Fields fields = new Fields();
                    fields.putObject("asString", (Object)o.getAsString());
                    return fields;
                }

                public void deserialize(EntitySnapshot o, Fields f) {
                    assert (false);
                }

                protected EntitySnapshot deserialize(Fields fields) throws StreamCorruptedException {
                    String asString = (String)fields.getObject("asString", String.class);
                    if (asString != null) {
                        return Bukkit.getEntityFactory().createEntitySnapshot(asString);
                    }
                    return null;
                }

                public boolean mustSyncDeserialization() {
                    return true;
                }

                protected boolean canBeInstantiated() {
                    return Constants.HAS_ENTITY_SNAPSHOT_GET_AS_STRING;
                }
            }));
        }
    }
}

