/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.inventory.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import it.jakegblp.lusk.utils.SkriptUtils;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="on Inventory Click - Clicked Item")
@Description(value={"Can be set."})
@Examples(value={"set clicked itemtype to stone"})
@Since(value={"1.3"})
public class ExprClickedItem
extends EventValueExpression<ItemStack> {
    public ExprClickedItem() {
        super(ItemStack.class, true);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = ItemStack.class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (event instanceof InventoryClickEvent) {
            Object object;
            InventoryClickEvent inventoryClickEvent = (InventoryClickEvent)event;
            if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                inventoryClickEvent.setCurrentItem(itemStack);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                inventoryClickEvent.setCurrentItem(ItemStack.empty());
            }
        }
    }

    static {
        SkriptUtils.register(ExprClickedItem.class, ItemStack.class, "[event-|the ]clicked item[stack|type]");
    }
}

