/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.inventory.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import it.jakegblp.lusk.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Used Tool/Used Hand/Used Equipment Slot")
@Description(value={"Retrieves the used hand or item used in events where either hand is used.\nThe first pattern returns the Slot (Item + Index) of the item in the used hand.\n- Note: using this is not the same as using `event-slot` or `event-item`, if either is available, use that\nThe second pattern returns an Equipment Slot that's either `hand_slot` or `off_hand_slot`.\n\nSupported Events:\n- on Right Click\n- on Item Consume\n- on Arm Swing\n- on Entity Shoot (different than 'on Shoot'!)\n- on Crossbow Load\n- on Place (includes 'on Block Place', 'on Hanging Place', and 'on Entity Place')\n- on Resurrect\n- on Player Fish\n- on Bucket Fill\n- on Bucket Empty\n- on Elytra Boost\n- on Player Harvest\n- on Can Build Check\n- on Player Shear Entity\n- on Player Leash Entity\n- on Player Unleash Entity\n- on Player Use Unknown Entity\n"})
@Examples(value={"broadcast event-used tool"})
@Since(value={"1.1, 1.1.1 (Optimized), 1.2 (Hand and Item, +1 Event, Fixes)"})
public class ExprUsedTool
extends SimpleExpression<Object> {
    private static final ArrayList<Class<? extends Event>> CLASSES = new ArrayList<Class<? extends Event>>(List.of(BlockCanBuildEvent.class, BlockPlaceEvent.class, EntityPlaceEvent.class, EntityResurrectEvent.class, EntityShootBowEvent.class, PlayerLeashEntityEvent.class, PlayerArmorStandManipulateEvent.class, PlayerBucketEntityEvent.class, PlayerBucketEvent.class, PlayerFishEvent.class, PlayerHarvestBlockEvent.class, PlayerInteractEntityEvent.class, PlayerInteractEvent.class, PlayerItemConsumeEvent.class, PlayerShearEntityEvent.class, PlayerUnleashEntityEvent.class, HangingPlaceEvent.class)){
        {
            if (Constants.PAPER_HAS_PLAYER_ARM_SWING_EVENT_HAND) {
                this.add(PlayerArmSwingEvent.class);
            }
            if (Constants.PAPER_HAS_ENTITY_LOAD_CROSSBOW_EVENT_HAND) {
                this.add(EntityLoadCrossbowEvent.class);
            }
            if (Constants.PAPER_HAS_PLAYER_ELYTRA_BOOST_EVENT_HAND) {
                this.add(PlayerElytraBoostEvent.class);
            }
            if (Constants.PAPER_HAS_PLAYER_SHEAR_BLOCK_EVENT_HAND) {
                this.add(PlayerShearBlockEvent.class);
            }
            if (Constants.PAPER_HAS_PLAYER_USE_UNKNOWN_ENTITY_EVENT_HAND) {
                this.add(PlayerUseUnknownEntityEvent.class);
            }
        }
    };
    boolean hand;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        for (Class<? extends Event> clazz : CLASSES) {
            if (!this.getParser().isCurrentEvent(clazz)) continue;
            this.hand = matchedPattern == 1;
            return true;
        }
        Skript.error((String)"The Hand Expression can only be used in events where Hands are involved.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        return false;
    }

    protected Object @NotNull [] get(@NotNull Event e) {
        org.bukkit.inventory.EquipmentSlot slot = null;
        Player player = null;
        LivingEntity entity = null;
        if (e instanceof BlockCanBuildEvent) {
            BlockCanBuildEvent event = (BlockCanBuildEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof BlockPlaceEvent) {
            BlockPlaceEvent event = (BlockPlaceEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof EntityPlaceEvent) {
            EntityPlaceEvent event = (EntityPlaceEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof EntityResurrectEvent) {
            EntityResurrectEvent event = (EntityResurrectEvent)e;
            slot = event.getHand();
            entity = event.getEntity();
        } else if (e instanceof EntityShootBowEvent) {
            EntityShootBowEvent event = (EntityShootBowEvent)e;
            slot = event.getHand();
            entity = event.getEntity();
        } else if (e instanceof PlayerLeashEntityEvent) {
            PlayerLeashEntityEvent event = (PlayerLeashEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof HangingPlaceEvent) {
            HangingPlaceEvent event = (HangingPlaceEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerArmorStandManipulateEvent) {
            PlayerArmorStandManipulateEvent event = (PlayerArmorStandManipulateEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerBucketEntityEvent) {
            PlayerBucketEntityEvent event = (PlayerBucketEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerBucketEvent) {
            PlayerBucketEvent event = (PlayerBucketEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerFishEvent) {
            PlayerFishEvent event = (PlayerFishEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerHarvestBlockEvent) {
            PlayerHarvestBlockEvent event = (PlayerHarvestBlockEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerInteractEntityEvent) {
            PlayerInteractEntityEvent event = (PlayerInteractEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerInteractEvent) {
            PlayerInteractEvent event = (PlayerInteractEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerItemConsumeEvent) {
            PlayerItemConsumeEvent event = (PlayerItemConsumeEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerShearEntityEvent) {
            PlayerShearEntityEvent event = (PlayerShearEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (e instanceof PlayerUnleashEntityEvent) {
            PlayerUnleashEntityEvent event = (PlayerUnleashEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (Constants.PAPER_HAS_PLAYER_SHEAR_BLOCK_EVENT_HAND && e instanceof PlayerShearBlockEvent) {
            PlayerShearBlockEvent event = (PlayerShearBlockEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (Constants.PAPER_HAS_ENTITY_LOAD_CROSSBOW_EVENT_HAND && e instanceof EntityLoadCrossbowEvent) {
            EntityLoadCrossbowEvent event = (EntityLoadCrossbowEvent)e;
            slot = event.getHand();
            entity = event.getEntity();
        } else if (Constants.PAPER_HAS_PLAYER_ARM_SWING_EVENT_HAND && e instanceof PlayerArmSwingEvent) {
            PlayerArmSwingEvent event = (PlayerArmSwingEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (Constants.PAPER_HAS_PLAYER_ELYTRA_BOOST_EVENT_HAND && e instanceof PlayerElytraBoostEvent) {
            PlayerElytraBoostEvent event = (PlayerElytraBoostEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        } else if (Constants.PAPER_HAS_PLAYER_USE_UNKNOWN_ENTITY_EVENT_HAND && e instanceof PlayerUseUnknownEntityEvent) {
            PlayerUseUnknownEntityEvent event = (PlayerUseUnknownEntityEvent)e;
            player = event.getPlayer();
            slot = event.getHand();
        }
        if (slot != null) {
            EntityEquipment entityEquipment;
            if (this.hand) {
                return new org.bukkit.inventory.EquipmentSlot[]{slot};
            }
            if (player != null) {
                PlayerInventory inventory = player.getInventory();
                return new InventorySlot[]{new InventorySlot((Inventory)inventory, slot == org.bukkit.inventory.EquipmentSlot.OFF_HAND ? 40 : inventory.getHeldItemSlot())};
            }
            if (entity != null && (entityEquipment = entity.getEquipment()) != null) {
                return new EquipmentSlot[]{new EquipmentSlot(entityEquipment, slot == org.bukkit.inventory.EquipmentSlot.OFF_HAND ? EquipmentSlot.EquipSlot.OFF_HAND : EquipmentSlot.EquipSlot.TOOL)};
            }
        }
        return new Object[0];
    }

    @NotNull
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the used " + (this.hand ? "hand" : "tool");
    }

    static {
        Skript.registerExpression(ExprUsedTool.class, Object.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] used (tool|[held] item|weapon)", "[[the] [used] |event-](hand [slot]|equipment[ ]slot)"});
    }
}

