/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.ItemUtils;

@Name(value="Armor - is Dyed")
@Description(value={"Checks whether the provided armor items are dyed (they don't have the default color).\nThis works for leather armor, horse leather armor and wolf armor.\n\nThis might not work correctly on Spigot.\n"})
@Examples(value={"if chestplate of player is dyed:"})
@Since(value={"1.3.3"})
public class CondArmorIsDyed
extends PropertyCondition<ItemType> {
    public boolean check(ItemType value) {
        return ItemUtils.isArmorDyed(value);
    }

    protected String getPropertyName() {
        return "dyed";
    }

    static {
        CondArmorIsDyed.register(CondArmorIsDyed.class, (String)"(dyed|colored)", (String)"itemtypes");
    }
}

