/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.ItemUtils;

@Name(value="Crossbow - has Charged Projectiles")
@Description(value={"Checks if one or more crossbows have any charged projectiles at all.\nThis behaves the same way the `is charged` condition behaves for crossbows."})
@Examples(value={"if tool of player has charged projectiles:"})
@Since(value={"1.3"})
public class CondHasChargedProjectiles
extends PropertyCondition<ItemType> {
    public boolean check(ItemType value) {
        return ItemUtils.hasChargedProjectiles(value);
    }

    protected String getPropertyName() {
        return "charged projectiles";
    }

    static {
        CondHasChargedProjectiles.register(CondHasChargedProjectiles.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"charged projectiles", (String)"itemtypes");
    }
}

