/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.ItemUtils;

@Name(value="Enchanted Book - has Stored Enchantments")
@Description(value={"Checks if one or more enchanted books have any stored enchantments at all."})
@Examples(value={"if tool of player has stored enchantments:"})
@Since(value={"1.3"})
public class CondHasStoredEnchantments
extends PropertyCondition<ItemType> {
    public boolean check(ItemType value) {
        return ItemUtils.hasStoredEnchantments(value);
    }

    protected String getPropertyName() {
        return "stored enchantments";
    }

    static {
        CondHasStoredEnchantments.register(CondHasStoredEnchantments.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"stored enchant[ment]s", (String)"itemtypes");
    }
}

