/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.ItemUtils;

@Name(value="Suspicious Stew - has Custom Potion Effects")
@Description(value={"Checks if the provided suspicious stews have any custom potion effects."})
@Examples(value={"if tool of player has custom potion effects:"})
@Since(value={"1.3.3"})
public class CondSuspiciousStewHasCustomEffects
extends PropertyCondition<ItemType> {
    public boolean check(ItemType value) {
        return ItemUtils.hasSuspiciousStewPotionEffects(value);
    }

    protected String getPropertyName() {
        return "custom potion effects";
    }

    static {
        CondSuspiciousStewHasCustomEffects.register(CondSuspiciousStewHasCustomEffects.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"[custom] potion effects", (String)"itemtypes");
    }
}

