/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Color;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.ItemUtils;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor - Color")
@Description(value={"Gets the color of the provided armor items.\nThis works for leather armor, horse leather armor and wolf armor.\nCan be set."})
@Examples(value={"if chestplate of player is dyed:"})
@Since(value={"1.3.3"})
public class ExprArmorColor
extends SimplerPropertyExpression<ItemType, Color> {
    @Nullable
    public Color convert(ItemType from) {
        return ItemUtils.getArmorColor(from);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(ItemType from, Color to) {
        ItemUtils.setArmorColor(from, to);
    }

    protected String getPropertyName() {
        return "armor color";
    }

    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    static {
        ExprArmorColor.register(ExprArmorColor.class, Color.class, (String)"armor color", (String)"itemtypes");
    }
}

