/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.ItemUtils;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Crossbow - Charged Projectiles")
@Description(value={"Returns the Projectile Items charged in the provided crossbows.\nCan be set, added to, removed from, reset and deleted."})
@Examples(value={"broadcast charged projectiles of tool"})
@Since(value={"1.3"})
public class ExprChargedProjectiles
extends PropertyExpression<ItemType, ItemType> {
    protected ItemType[] get(Event event, ItemType[] source) {
        return (ItemType[])Arrays.stream(source).flatMap(itemType -> Arrays.stream(ItemUtils.getChargedProjectiles(itemType))).toArray(ItemType[]::new);
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "charged projectiles of " + this.getExpr().toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{ItemType[].class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            case Changer.ChangeMode.REMOVE_ALL -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] source = (ItemType[])this.getExpr().getArray(event);
        ItemType[] projectiles = (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) && delta == null ? null : (ItemType[])delta;
        switch (mode) {
            case ADD: {
                for (ItemType item : source) {
                    ItemUtils.addChargedProjectiles(item, projectiles);
                }
                break;
            }
            case REMOVE: {
                for (ItemType item : source) {
                    ItemUtils.removeChargedProjectiles(item, projectiles);
                }
                break;
            }
            case SET: 
            case DELETE: 
            case RESET: {
                for (ItemType item : source) {
                    ItemUtils.setChargedProjectiles(item, projectiles);
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprChargedProjectiles.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] charged projectiles (in|of) %itemtypes%", "[the] projectiles charged in %itemtypes%", "%itemtypes%'[s] charged projectiles"});
    }
}

