/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.ItemUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Item - Supported/Preferred Enchantments")
@Description(value={"Returns the Enchantments this item can normally have."})
@Examples(value={"broadcast supported enchantments of tool"})
@Since(value={"1.3, 1.3.9 (Fixed Plurality)"})
public class ExprSupportedEnchantments
extends PropertyExpression<ItemStack, Enchantment> {
    protected Enchantment[] get(Event event, ItemStack[] source) {
        return (Enchantment[])Arrays.stream(source).flatMap(itemStack -> Stream.of(ItemUtils.getSupportedEnchantments(itemStack))).toArray(Enchantment[]::new);
    }

    public Class<? extends Enchantment> getReturnType() {
        return Enchantment.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "supported enchantments of " + this.getExpr().toString(event, debug);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    static {
        ExprSupportedEnchantments.register(ExprSupportedEnchantments.class, Enchantment.class, "(preferred|supported) enchantments", "itemstacks");
    }
}

