/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.ItemUtils;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

@Name(value="Suspicious Stew - Custom Potion Effects")
@Description(value={"Gets the custom potion effects applied to the provided suspicious stew.\n\nCan be: set, added to, removed from, removed all x from, cleared and reset.\nClear and reset do the same thing, same for remove and remove all.\nRemove and remove all can take either potion effects or potion effect types.\n"})
@Examples(value={"set suspicious stew potion effects to strength potion effect of strength of tier 1 for 15 seconds"})
@Since(value={"1.3.3"})
public class ExprSuspiciousStewCustomPotionEffects
extends PropertyExpression<ItemType, PotionEffect> {
    protected PotionEffect[] get(Event event, ItemType[] source) {
        return (PotionEffect[])Arrays.stream(source).flatMap(itemType -> Arrays.stream(ItemUtils.getSuspiciousStewPotionEffects(itemType))).toArray(PotionEffect[]::new);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class});
            case Changer.ChangeMode.REMOVE, Changer.ChangeMode.REMOVE_ALL -> (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class, PotionEffectType[].class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] itemTypes = (ItemType[])this.getExpr().getArray(event);
        switch (mode) {
            case ADD: {
                for (ItemType item : itemTypes) {
                    ItemUtils.addSuspiciousStewPotionEffects(item, (PotionEffect[])delta);
                }
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                for (ItemType item : itemTypes) {
                    ItemUtils.removeSuspiciousStewPotionEffects(item, delta);
                }
                break;
            }
            case SET: {
                for (ItemType item : itemTypes) {
                    ItemUtils.setSuspiciousStewPotionEffects(item, (PotionEffect[])delta);
                }
                break;
            }
            case DELETE: 
            case RESET: {
                for (ItemType item : itemTypes) {
                    ItemUtils.clearSuspiciousStewPotionEffects(item);
                }
                break;
            }
        }
    }

    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "suspicious stew potion effects of " + this.getExpr().toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    static {
        ExprSuspiciousStewCustomPotionEffects.register(ExprSuspiciousStewCustomPotionEffects.class, PotionEffect.class, "suspicious stew [custom] potion effects", "itemtypes");
    }
}

