/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.ItemUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Item - Unenchanted/Disenchanted")
@Description(value={"Returns one or more items without enchantments."})
@Examples(value={"set tool to unenchanted tool\n# removes all the enchantments"})
@Since(value={"1.0.2, 1.3 (plural)"})
public class ExprUnenchanted
extends SimpleExpression<ItemType> {
    private Expression<ItemType> itemTypeExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.itemTypeExpression = exprs[0];
        return true;
    }

    protected ItemType @NotNull [] get(@NotNull Event e) {
        return ItemUtils.unenchant((ItemType[])this.itemTypeExpression.getAll(e));
    }

    public boolean isSingle() {
        return this.itemTypeExpression.isSingle();
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "unenchanted " + this.itemTypeExpression.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprUnenchanted.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"unenchanted %itemtypes%", "disenchanted %itemtypes%"});
    }
}

