/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.mixed.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.paperlib.PaperLib;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;

@Name(value="Entity/Block/BlockState/Item - is Collidable")
@Description(value={"Checks whether the provided living entities, blocks, blockstates and items are collidable.\n\nInfo:\n- LivingEntity: Some entities might be exempted from the collidable rule of this entity. Use the \"Entity - Collidable Exemptions\" expression to get these. Please note that this method returns only the custom collidable state, not whether the entity is non-collidable for other reasons such as being dead.\n"})
@Examples(value={""})
@Since(value={"1.3"})
public class CondIsCollidable
extends PropertyCondition<Object> {
    public boolean check(Object value) {
        ItemType itemType;
        if (value instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)value;
            return livingEntity.isCollidable();
        }
        if (!Constants.MINECRAFT_1_18_2 || !PaperLib.isPaper()) {
            return false;
        }
        if (value instanceof BlockState) {
            BlockState blockState = (BlockState)value;
            return blockState.isCollidable();
        }
        if (value instanceof Block) {
            Block block = (Block)value;
            return block.isCollidable();
        }
        if (value instanceof ItemType && (itemType = (ItemType)value).getMaterial().isBlock()) {
            return itemType.getMaterial().isCollidable();
        }
        return false;
    }

    protected String getPropertyName() {
        return "placed";
    }

    static {
        CondIsCollidable.register(CondIsCollidable.class, (String)"collidable [with]", (String)("livingentities" + (Constants.MINECRAFT_1_18_2 && PaperLib.isPaper() ? "/blocks/blockstates/itemtypes" : "")));
    }
}

