/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.mixed.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.enums.Axis4D;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.VectorUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="AxisAngle/Quaternion/Vector(2D/3D/4D)/Location/EulerAngle/Chunk - XYZ(W) Coordinate/Coordinate List")
@Description(value={"Gets a list or one of the coordinates of:\n- Locations\n- Vectors\n- Chunks (only X and Z)\n- EulerAngles\n- 2D Vectors (only X and Z)\n- 3D Vectors\n- 4D Vectors (XYZW)\n- Quaternions (XYZW)\n- AxisAngles (XYZW)\n- MapCursor\n\nNote: Out of all of these Lusk only implements EulerAngles.\n"})
@Examples(value={"broadcast coordinates of {_loc}"})
@Since(value={"1.3"})
public class ExprCoordinates
extends PropertyExpression<Object, Number> {
    private Axis4D selectedAxis = null;
    private boolean list;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.list = parser.hasTag("list");
        if (!this.list) {
            this.selectedAxis = Axis4D.valueOf(((String)parser.tags.getFirst()).toUpperCase(Locale.ENGLISH));
        }
        this.setExpr(vars[0]);
        return true;
    }

    @NotNull
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    public boolean isSingle() {
        return !this.list && this.getExpr().isSingle();
    }

    protected Number @NotNull [] get(@NotNull Event e, Object @NotNull [] source) {
        if (this.list) {
            return (Number[])Arrays.stream(Axis4D.values()).flatMap(axis -> this.getExpr().stream(e).map(o -> VectorUtils.getCoordinate(o, axis)).filter(Objects::nonNull)).toArray(Number[]::new);
        }
        return (Number[])this.getExpr().stream(e).map(o -> VectorUtils.getCoordinate(o, this.selectedAxis)).toArray(Number[]::new);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (String)(this.list ? "the coordinates of " : "the " + this.selectedAxis.name().toLowerCase(Locale.ENGLISH) + " coordinate component of ") + this.getExpr().toString(event, debug);
    }

    static {
        ExprCoordinates.register(ExprCoordinates.class, Number.class, "(list:coord[inate](s| list)|(:x|:y|:z|w)[( |-)(coord[inate]|pos[ition]|loc[ation])] component)", "objects");
    }
}

