/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.server.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server - allows Nether/End/Flight")
@Description(value={"Checks if the server allows the Nether, the End or Flight"})
@Examples(value={"if the server does not allow the end:\n\tbroadcast \"No End here!\""})
@Since(value={"1.0.0, 1.0.3 (is Allowed), 1.2 (Flight)"})
public class CondServerAllows
extends Condition {
    private Boolean end;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.end = parser.hasTag("end") ? Boolean.TRUE : (parser.hasTag("nether") ? Boolean.valueOf(false) : null);
        this.setNegated(matchedPattern == 1 || parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (String)(this.end == null ? "flight" : "the " + (this.end != false ? "end" : "nether")) + " is" + (this.isNegated() ? " not" : "") + " allowed";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ (this.end == null ? Bukkit.getAllowFlight() : (this.end != false ? Bukkit.getAllowEnd() : Bukkit.getAllowNether()));
    }

    static {
        Skript.registerCondition(CondServerAllows.class, (String[])new String[]{"[the] server allows ([the] (:end|:nether)|(to fly|flight))", "[the] server does(n'| no)t allow ([the] (:end|:nether)|(to fly|flight))", "([the] (:end|:nether)|flight) is[not:(n't| not)] (allowed|enabled)"});
    }
}

