/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.server.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server - Whitelist is Enabled")
@Description(value={"Checks whether the server has a whitelist or not."})
@Examples(value={"if the whitelist is enabled:"})
@Since(value={"1.0.2"})
public class CondWhitelistEnabled
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the whitelist is " + (this.isNegated() ? "disabled" : "enabled");
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ Bukkit.hasWhitelist();
    }

    static {
        Skript.registerCondition(CondWhitelistEnabled.class, (String[])new String[]{"[the] whitelist is enabled", "[the] whitelist is disabled"});
    }
}

