/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.server.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server - Whitelist is Enforced")
@Description(value={"Checks whether the whitelist is enforced. If the whitelist is enforced, non-whitelisted players will be disconnected when the server whitelist is reloaded."})
@Examples(value={"if the whitelist is not enforced:"})
@Since(value={"1.0.2"})
public class CondWhitelistEnforced
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the whitelist is " + (this.isNegated() ? "not " : "") + "enforced";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ Bukkit.isWhitelistEnforced();
    }

    static {
        Skript.registerCondition(CondWhitelistEnforced.class, (String[])new String[]{"[the] whitelist is enforced", "[the] whitelist is not enforced"});
    }
}

