/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.server.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Toggle Whitelist")
@Description(value={"Sets if the server is whitelisted."})
@Examples(value={"enable whitelist"})
@Since(value={"1.0.2"})
public class EffToggleWhitelist
extends Effect {
    private boolean enable;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.enable = parser.hasTag("en");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.enable ? "en" : "dis") + "able the server whitelist";
    }

    protected void execute(@NotNull Event event) {
        Bukkit.setWhitelist((boolean)this.enable);
    }

    static {
        Skript.registerEffect(EffToggleWhitelist.class, (String[])new String[]{"(:en|dis)able [the] [server] whitelist"});
    }
}

