/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.world.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Change is Instant")
@Description(value={"This Condition requires Paper.\n\nChecks whether or not the worldborder change is instant in the worldborder change event"})
@Examples(value={"on world border start changing:\n  if the world border change is instant:\n    broadcast \"instant\"\n  else:\n    broadcast \"not instant\"\n"})
@Since(value={"1.0.2"})
@RequiredPlugins(value={"Paper"})
public class CondIsInstantWorldBorderChange
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(WorldBorderBoundsChangeEvent.class)) {
            Skript.error((String)"This condition can only be used in the WorldBorder Change event!");
            return false;
        }
        this.setNegated(parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the worldborder change is " + (this.isNegated() ? "not " : "") + "instant";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((WorldBorderBoundsChangeEvent)event).getType() == WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE;
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent")) {
            Skript.registerCondition(CondIsInstantWorldBorderChange.class, (String[])new String[]{"[the] world[ ]border change is[not:n('|o)t] instant"});
        }
    }
}

