/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.world.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.coll.CollectionUtils;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtWorldBorderChange
extends SkriptEvent {
    private int pattern;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (e instanceof WorldBorderBoundsChangeEvent) {
            return this.pattern == 0;
        }
        if (e instanceof WorldBorderBoundsChangeFinishEvent) {
            return this.pattern == 1;
        }
        return this.pattern == 2;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.pattern == 0 ? "worldborder start changing" : (this.pattern == 1 ? "worldborder stop changing" : "worldborder center change");
    }

    static {
        if (Constants.PAPER_HAS_WORLD_BORDER_EVENT) {
            Skript.registerEvent((String)"WorldBorder - on Change/Center Change", EvtWorldBorderChange.class, (Class[])((Class[])CollectionUtils.array((Object[])new Class[]{WorldBorderBoundsChangeEvent.class, WorldBorderBoundsChangeFinishEvent.class, WorldBorderCenterChangeEvent.class})), (String[])new String[]{"world[ ]border start[ing|ed] [to] chang(e|ing)", "world[ ]border stop chang(e|ing)", "world[ ]border center chang(e[d]|ing)"}).description(new String[]{"Called when a world border's center is changed or when a world border starts (either over time or instantly) or stops moving."}).examples(new String[]{"on world border start changing:\n  if the world border change is instant:\n    broadcast \"instant\"\n  else:\n    broadcast \"not instant\"\n"}).since("1.0.2").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(WorldBorderEvent.class, World.class, WorldEvent::getWorld, 0);
        }
    }
}

