/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.world.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Past/Future World Border Center")
@Description(value={"Returns the past/future center of the world border in the World Border Change events.\nThe future center can be set."})
@Examples(value={""})
@Since(value={"1.0.2"})
@RequiredPlugins(value={"Paper"})
public class ExprWorldBorderCenterChangeCenter
extends SimpleExpression<Location> {
    private Boolean past;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(WorldBorderCenterChangeEvent.class)) {
            Skript.error((String)"This expression can only be used in the World Border Change events.!");
            return false;
        }
        this.past = parseResult.hasTag("past");
        return true;
    }

    protected Location @NotNull [] get(@NotNull Event e) {
        WorldBorderCenterChangeEvent event = (WorldBorderCenterChangeEvent)e;
        Location location = this.past != false ? event.getOldCenter() : event.getNewCenter();
        return new Location[]{location};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Location.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Location) {
            Location location = (Location)object;
            ((WorldBorderCenterChangeEvent)e).setNewCenter(location);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the" + (this.past == null ? "" : (this.past != false ? " past" : " future")) + " worldborder center";
    }

    static {
        if (Constants.PAPER_HAS_WORLD_BORDER_EVENT) {
            Skript.registerExpression(ExprWorldBorderCenterChangeCenter.class, Location.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] [future|:past] world[ ]border center"});
        }
    }
}

