/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.world.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Change Duration")
@Description(value={"Returns the duration of the change in the World Border Start Change event.\nCan be set.\nRequires Paper."})
@Examples(value={""})
@Since(value={"1.0.2, 1.3 (Milliseconds)"})
@RequiredPlugins(value={"Paper"})
public class ExprWorldBorderChangeDuration
extends SimpleExpression<Object> {
    private boolean usesMilliseconds;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(WorldBorderBoundsChangeEvent.class)) {
            Skript.error((String)"This expression can only be used in the World Border Change events.!");
            return false;
        }
        this.usesMilliseconds = parseResult.hasTag("millis");
        return true;
    }

    protected Object @NotNull [] get(@NotNull Event e) {
        WorldBorderBoundsChangeEvent event = (WorldBorderBoundsChangeEvent)e;
        return new Object[]{this.usesMilliseconds ? Long.valueOf(event.getDuration()) : new Timespan(event.getDuration())};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = this.usesMilliseconds ? Long.class : Timespan.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object;
        WorldBorderBoundsChangeEvent event = (WorldBorderBoundsChangeEvent)e;
        if (this.usesMilliseconds && (object = delta[0]) instanceof Long) {
            Long aLong = (Long)object;
            event.setDuration(aLong.longValue());
        } else {
            object = delta[0];
            if (object instanceof Timespan) {
                Timespan timespan = (Timespan)object;
                event.setDuration(CompatibilityUtils.getMilliseconds(timespan));
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the world border change duration" + (this.usesMilliseconds ? " in milliseconds" : "");
    }

    static {
        if (Constants.PAPER_HAS_WORLD_BORDER_EVENT) {
            Skript.registerExpression(ExprWorldBorderChangeDuration.class, Object.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] world[ |-]border (shift|change) duration [millis:in milliseconds]"});
        }
    }
}

