/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Small Capital Case")
@Description(value={"Returns the given string with the small font.\n'Lenient' allows uppercase characters to not be included."})
@Examples(value={"broadcast player's name in small caps", "set chat format to small caps \"%player%: %message%\""})
@Since(value={"1.0.0, 1.3 (Lenient)"})
public class ExprCases
extends SimpleExpression<String> {
    public static Character[] characters = new Character[]{Character.valueOf('\u1d00'), Character.valueOf('\u0299'), Character.valueOf('\u1d04'), Character.valueOf('\u1d05'), Character.valueOf('\u1d07'), Character.valueOf('\u0493'), Character.valueOf('\u0262'), Character.valueOf('\u029c'), Character.valueOf('\u026a'), Character.valueOf('\u1d0a'), Character.valueOf('\u1d0b'), Character.valueOf('\u029f'), Character.valueOf('\u1d0d'), Character.valueOf('\u0274'), Character.valueOf('\u1d0f'), Character.valueOf('\u1d18'), Character.valueOf('\u01eb'), Character.valueOf('\u0280'), Character.valueOf('s'), Character.valueOf('\u1d1b'), Character.valueOf('\u1d1c'), Character.valueOf('\u1d20'), Character.valueOf('\u1d21'), Character.valueOf('x'), Character.valueOf('\u028f'), Character.valueOf('\u1d22')};
    private Expression<String> string;
    private boolean lenient;

    public static String toSmallFont(String string, boolean strict) {
        String regex = strict ? "[a-zA-Z]" : "[a-z]";
        for (String letter : string.split("")) {
            if (!letter.matches(regex)) continue;
            string = string.replaceAll(letter, String.valueOf(characters[Character.getNumericValue(letter.charAt(0)) - 10]));
        }
        return string;
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.lenient = parseResult.hasTag("lenient");
        this.string = exprs[0];
        return true;
    }

    protected String @NotNull [] get(@NotNull Event e) {
        String s = (String)this.string.getSingle(e);
        if (s != null) {
            return new String[]{ExprCases.toSmallFont(s, !this.lenient)};
        }
        return new String[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return (this.lenient ? "lenient " : "") + "small caps " + this.string.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCases.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%string% in [:lenient|strict|fully] small (font|[upper[ ]]case|cap(s|ital[ case]))", "[:lenient|strict|fully] small (font|[upper[ ]]case|cap(s|ital[ case])) %string%"});
    }
}

