/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.version.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.vdurmont.semver4j.Semver;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Name(value="Player - Client Version")
@Description(value={"Returns the Minecraft version of a player, snapshots are not included."})
@Examples(value={"broadcast version of player\n\nif version of player = 1.19.3:\n    send \"why so specific of a version?\"\n\nif version of player < 1.9.0:\n    send \"i think you should update but you do you\"\n"})
@Since(value={"1.0.0, 1.3.9 (Plural)"})
public class ExprPlayerVersion
extends SimplePropertyExpression<Player, Semver> {
    @NotNull
    public Class<? extends Semver> getReturnType() {
        return Semver.class;
    }

    public Semver convert(Player p) {
        return Constants.versions.get(p.getProtocolVersion());
    }

    @NotNull
    protected String getPropertyName() {
        return "client version";
    }

    static {
        ExprPlayerVersion.register(ExprPlayerVersion.class, Semver.class, (String)"[minecraft|client|player] version", (String)"players");
    }
}

