/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.paperlib.PaperLib;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.google.common.collect.ImmutableMap;
import com.vdurmont.semver4j.Semver;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import it.jakegblp.lusk.api.SkriptAdapter;
import it.jakegblp.lusk.utils.LuskUtils;
import it.jakegblp.lusk.utils.RegistryUtils;
import it.jakegblp.lusk.utils.VersionResolver;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;

public class Constants {
    public static final double EPSILON = 1.0E-7;
    public static final String[] LUSK_COLORS = new String[]{"&7", "&9"};
    public static final Pattern REGEX_TRUNCATED_VERSION = Pattern.compile("^\\d+\\.\\d+(\\.\\d+)?");
    public static final Pattern REGEX_VERSION = Pattern.compile("^\\d+\\.\\d+(\\.\\d+)?[-+a-zA-Z0-9.]*$");
    public static final Pattern REGEX_NUMBER_WITH_DECIMAL = Pattern.compile("(\\d+.\\d+)");
    public static final Semver VERSION_SERVER = LuskUtils.parseVersion(String.valueOf(Skript.getMinecraftVersion()));
    public static final Semver VERSION_SERVER_OLDEST_SUPPORTED = LuskUtils.parseVersion("1.16");
    public static final Semver VERSION_SERVER_NEWEST_SUPPORTED = LuskUtils.parseVersion("1.21.4");
    public static final Semver VERSION_SKRIPT = LuskUtils.parseVersionTruncated(Skript.getVersion().toString());
    public static final Semver VERSION_SKRIPT_OLDEST_SUPPORTED = LuskUtils.parseVersion("2.6");
    public static final Semver VERSION_SKRIPT_NEWEST_SUPPORTED = LuskUtils.parseVersion("2.10");
    public static final SkriptAdapter ADAPTER_SKRIPT = VersionResolver.getSkriptAdapter(VERSION_SKRIPT);
    public static final List<InventoryAction> DROP_ACTION_DATA = List.of(InventoryAction.DROP_ONE_SLOT, InventoryAction.DROP_ALL_SLOT, InventoryAction.DROP_ALL_CURSOR, InventoryAction.DROP_ONE_CURSOR);
    public static final List<InventoryAction> PICKUP_ACTION_DATA = List.of(InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_SOME);
    public static final List<InventoryAction> PLACE_ACTION_DATA = List.of(InventoryAction.PLACE_ONE, InventoryAction.PLACE_ALL, InventoryAction.PLACE_SOME);
    public static final boolean HAS_BELL_RESONATE_EVENT = Skript.classExists((String)"org.bukkit.event.block.BellResonateEvent");
    public static final boolean SPIGOT_HAS_BELL_RING_EVENT = Skript.classExists((String)"org.bukkit.event.block.BellRingEvent");
    public static final boolean HAS_VOXEL_SHAPE = Skript.classExists((String)"org.bukkit.util.VoxelShape");
    public static final boolean HAS_SPAWN_CATEGORY = Skript.classExists((String)"org.bukkit.entity.SpawnCategory");
    public static final boolean HAS_ENTITY_SNAPSHOT = Skript.classExists((String)"org.bukkit.entity.EntitySnapshot");
    public static final boolean HAS_ENTITY_SNAPSHOT_GET_AS_STRING = HAS_ENTITY_SNAPSHOT && Skript.methodExists(EntitySnapshot.class, (String)"getAsString", (Class[])new Class[0]);
    public static final boolean HAS_STRUCTURE_PIECE = Skript.classExists((String)"org.bukkit.generator.structure.StructurePiece");
    public static final boolean HAS_GENERATED_STRUCTURE = Skript.classExists((String)"org.bukkit.generator.structure.GeneratedStructure");
    public static final boolean SPIGOT_HAS_ITEM_RARITY = Skript.classExists((String)"org.bukkit.inventory.ItemRarity");
    public static final boolean HAS_WARDEN = Skript.classExists((String)"org.bukkit.entity.Warden");
    public static final boolean HAS_SALMON_VARIANT = Skript.classExists((String)"org.bukkit.entity.Salmon$Variant");
    public static final boolean HAS_WOLF_VARIANT = Skript.classExists((String)"org.bukkit.entity.Wolf$Variant");
    public static final boolean HAS_COW_VARIANT = Skript.classExists((String)"org.bukkit.entity.Cow$Variant");
    public static final boolean HAS_PIG_VARIANT = Skript.classExists((String)"org.bukkit.entity.Pig$Variant");
    public static final boolean HAS_CHICKEN_VARIANT = Skript.classExists((String)"org.bukkit.entity.Chicken$Variant");
    public static final boolean HAS_FROG_VARIANT = Skript.classExists((String)"org.bukkit.entity.Frog$Variant");
    public static final boolean HAS_AXOLOTL_VARIANT = Skript.classExists((String)"org.bukkit.entity.Axolotl$Variant");
    public static final boolean HAS_REMOVE_ENCHANTMENTS_METHOD = Skript.methodExists(ItemStack.class, (String)"removeEnchantments", (Class[])new Class[0]);
    public static final boolean HAS_BLOCK_BREAK_EVENT_DROPS_ITEMS = Skript.methodExists(BlockBreakEvent.class, (String)"isDropsItems", (Class[])new Class[0]);
    public static final boolean SKRIPT_2_7 = VERSION_SKRIPT.isGreaterThanOrEqualTo(LuskUtils.parseVersion("2.7"));
    public static final boolean SKRIPT_2_8 = VERSION_SKRIPT.isGreaterThanOrEqualTo(LuskUtils.parseVersion("2.8"));
    public static final boolean SKRIPT_2_9 = VERSION_SKRIPT.isGreaterThanOrEqualTo(LuskUtils.parseVersion("2.9"));
    public static final boolean SKRIPT_2_10 = VERSION_SKRIPT.isGreaterThanOrEqualTo(LuskUtils.parseVersion("2.10"));
    public static final boolean MINECRAFT_1_18 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.18"));
    public static final boolean MINECRAFT_1_18_2 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.18.2"));
    public static final boolean MINECRAFT_1_19_2 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.19.2"));
    public static final boolean MINECRAFT_1_20 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20"));
    public static final boolean MINECRAFT_1_20_1 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20.1"));
    public static final boolean MINECRAFT_1_20_2 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20.2"));
    public static final boolean MINECRAFT_1_20_4 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20.4"));
    public static final boolean MINECRAFT_1_20_5 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20.5"));
    public static final boolean MINECRAFT_1_20_6 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.20.6"));
    public static final boolean MINECRAFT_1_21 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.21"));
    public static final boolean MINECRAFT_1_21_2 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.21.2"));
    public static final boolean MINECRAFT_1_21_5 = VERSION_SERVER.isGreaterThanOrEqualTo(LuskUtils.parseVersion("1.21.5"));
    public static final boolean SKRIPT_HAS_TIMESPAN_TIMEPERIOD = Skript.classExists((String)"ch.njol.skript.util.Timespan$TimePeriod");
    public static final boolean HAS_START_RIPTIDE_ATTACK = Skript.methodExists(HumanEntity.class, (String)"startRiptideAttack", (Class[])new Class[]{Integer.TYPE, Float.TYPE, ItemStack.class});
    public static final boolean HAS_HOPPER_INVENTORY_SEARCH_EVENT = Skript.classExists((String)"org.bukkit.event.inventory.HopperInventorySearchEvent");
    public static final boolean PAPER_HAS_ARMOR_STAND_META = Skript.classExists((String)"com.destroystokyo.paper.inventory.meta.ArmorStandMeta");
    public static final boolean PAPER_1_18 = MINECRAFT_1_18 && PaperLib.isPaper();
    public static final boolean PAPER_1_18_2 = MINECRAFT_1_18_2 && PaperLib.isPaper();
    public static final boolean PAPER_1_19_2 = MINECRAFT_1_19_2 && PaperLib.isPaper();
    public static final boolean PAPER_1_20_1 = MINECRAFT_1_20_1 && PaperLib.isPaper();
    public static final boolean PAPER_1_20_4 = MINECRAFT_1_20_4 && PaperLib.isPaper();
    public static final boolean PAPER_1_20_6 = MINECRAFT_1_20_6 && PaperLib.isPaper();
    public static final boolean PAPER_1_21 = MINECRAFT_1_21 && PaperLib.isPaper();
    public static final boolean PAPER_HAS_ENDER_SIGNAL_SET_TARGET_LOCATION = Skript.methodExists(EnderSignal.class, (String)"setTargetLocation", (Class[])new Class[]{Location.class, Boolean.TYPE});
    public static final boolean PAPER_HAS_WORLD_BORDER_EVENT = Skript.classExists((String)"io.papermc.paper.event.world.border.WorldBorderEvent");
    public static final boolean PAPER_HAS_PLAYER_ARM_SWING_EVENT = Skript.classExists((String)"io.papermc.paper.event.player.PlayerArmSwingEvent");
    public static final boolean PAPER_HAS_PLAYER_ARM_SWING_EVENT_HAND = PAPER_HAS_PLAYER_ARM_SWING_EVENT && Skript.methodExists(PlayerArmSwingEvent.class, (String)"getHand", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_ENTITY_LOAD_CROSSBOW_EVENT = Skript.classExists((String)"io.papermc.paper.event.entity.EntityLoadCrossbowEvent");
    public static final boolean PAPER_HAS_ENTITY_LOAD_CROSSBOW_EVENT_HAND = PAPER_HAS_ENTITY_LOAD_CROSSBOW_EVENT && Skript.methodExists(EntityLoadCrossbowEvent.class, (String)"getHand", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_PLAYER_SHEAR_BLOCK_EVENT = Skript.classExists((String)"io.papermc.paper.event.block.PlayerShearBlockEvent");
    public static final boolean PAPER_HAS_PLAYER_SHEAR_BLOCK_EVENT_HAND = PAPER_HAS_PLAYER_SHEAR_BLOCK_EVENT && Skript.methodExists(PlayerShearBlockEvent.class, (String)"getHand", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_PLAYER_ELYTRA_BOOST_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.player.PlayerElytraBoostEvent");
    public static final boolean PAPER_HAS_PLAYER_ELYTRA_BOOST_EVENT_HAND = PAPER_HAS_PLAYER_ELYTRA_BOOST_EVENT && Skript.methodExists(PlayerElytraBoostEvent.class, (String)"getHand", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_PLAYER_USE_UNKNOWN_ENTITY_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent");
    public static final boolean PAPER_HAS_PLAYER_USE_UNKNOWN_ENTITY_EVENT_HAND = PAPER_HAS_PLAYER_USE_UNKNOWN_ENTITY_EVENT && Skript.methodExists(PlayerUseUnknownEntityEvent.class, (String)"getHand", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_PLAYER_JUMP_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.player.PlayerJumpEvent");
    public static final boolean PAPER_HAS_ENTITY_JUMP_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.entity.EntityJumpEvent");
    public static final boolean PAPER_HAS_PAPER_REGISTRY_ACCESS = Skript.classExists((String)"io.papermc.paper.registry.RegistryAccess") && Skript.methodExists(RegistryAccess.class, (String)"registryAccess", (Class[])new Class[0]);
    public static final boolean PAPER_HAS_PAPER_REGISTRY_KEY = PAPER_HAS_PAPER_REGISTRY_ACCESS && Skript.classExists((String)"io.papermc.paper.registry.RegistryKey") && Skript.methodExists(RegistryAccess.class, (String)"getRegistry", (Class[])new Class[]{RegistryKey.class});
    public static final String ANVIL_GUI_PREFIX = "[lusk] anvil[(-| )gui]";
    public static final String ARMOR_STAND_PREFIX = "[armor[ |-]stand]";
    public static final String ARMOR_STAND_TYPES = "livingentity" + (PAPER_HAS_ARMOR_STAND_META ? "/itemtypes" : "");
    public static final String LUSK_PREFIX = MessageFormat.format("{0}[{1}Lusk{0}] ", LUSK_COLORS[0], LUSK_COLORS[1]);
    public static final ExpressionType EVENT_OR_SIMPLE = SKRIPT_2_8 ? ExpressionType.EVENT : ExpressionType.SIMPLE;
    public static final ImmutableMap<Class<?>, Registry<?>> REGISTRIES = RegistryUtils.generateRegistries();
    public static final Map<Integer, Semver> versions = Map.ofEntries(Map.entry(4, LuskUtils.parseVersion("1.7.5")), Map.entry(5, LuskUtils.parseVersion("1.7.10")), Map.entry(47, LuskUtils.parseVersion("1.8.9")), Map.entry(107, LuskUtils.parseVersion("1.9")), Map.entry(108, LuskUtils.parseVersion("1.9.1")), Map.entry(109, LuskUtils.parseVersion("1.9.2")), Map.entry(110, LuskUtils.parseVersion("1.9.4")), Map.entry(210, LuskUtils.parseVersion("1.10.2")), Map.entry(315, LuskUtils.parseVersion("1.11")), Map.entry(316, LuskUtils.parseVersion("1.11.2")), Map.entry(335, LuskUtils.parseVersion("1.12.0")), Map.entry(338, LuskUtils.parseVersion("1.12.1")), Map.entry(340, LuskUtils.parseVersion("1.12.2")), Map.entry(393, LuskUtils.parseVersion("1.13")), Map.entry(401, LuskUtils.parseVersion("1.13.1")), Map.entry(404, LuskUtils.parseVersion("1.13.2")), Map.entry(477, LuskUtils.parseVersion("1.14")), Map.entry(480, LuskUtils.parseVersion("1.14.1")), Map.entry(485, LuskUtils.parseVersion("1.14.2")), Map.entry(490, LuskUtils.parseVersion("1.14.3")), Map.entry(498, LuskUtils.parseVersion("1.14.4")), Map.entry(573, LuskUtils.parseVersion("1.15")), Map.entry(575, LuskUtils.parseVersion("1.15.1")), Map.entry(577, LuskUtils.parseVersion("1.15.2")), Map.entry(735, LuskUtils.parseVersion("1.16")), Map.entry(736, LuskUtils.parseVersion("1.16.1")), Map.entry(751, LuskUtils.parseVersion("1.16.2")), Map.entry(753, LuskUtils.parseVersion("1.16.3")), Map.entry(754, LuskUtils.parseVersion("1.16.5")), Map.entry(755, LuskUtils.parseVersion("1.17")), Map.entry(756, LuskUtils.parseVersion("1.17.1")), Map.entry(757, LuskUtils.parseVersion("1.18.1")), Map.entry(758, LuskUtils.parseVersion("1.18.2")), Map.entry(759, LuskUtils.parseVersion("1.19")), Map.entry(760, LuskUtils.parseVersion("1.19.2")), Map.entry(761, LuskUtils.parseVersion("1.19.3")), Map.entry(762, LuskUtils.parseVersion("1.19.4")), Map.entry(763, LuskUtils.parseVersion("1.20.1")), Map.entry(764, LuskUtils.parseVersion("1.20.2")), Map.entry(765, LuskUtils.parseVersion("1.20.4")), Map.entry(766, LuskUtils.parseVersion("1.20.6")), Map.entry(767, LuskUtils.parseVersion("1.21.1")), Map.entry(768, LuskUtils.parseVersion("1.21.3")), Map.entry(769, LuskUtils.parseVersion("1.21.4")), Map.entry(770, LuskUtils.parseVersion("1.21.5")), Map.entry(771, LuskUtils.parseVersion("1.21.6")), Map.entry(772, LuskUtils.parseVersion("1.21.8")), Map.entry(773, LuskUtils.parseVersion("1.21.10")));
}

