/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.utils;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.paperlib.PaperLib;
import it.jakegblp.lusk.utils.Constants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.AbstractCow;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    public static final Class<?> COW_CLASS;
    @Nullable
    public static final Method COW_GET_VARIANT_METHOD;
    @Nullable
    public static final Method COW_SET_VARIANT_METHOD;

    public static boolean shouldBurnDuringTheDay(LivingEntity entity) {
        if (!PaperLib.isPaper()) {
            return false;
        }
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            return zombie.shouldBurnInDay();
        }
        if (Constants.MINECRAFT_1_18_2 && entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            return skeleton.shouldBurnInDay();
        }
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            try {
                return (Boolean)Skeleton.class.getMethod("shouldBurnInDay", new Class[0]).invoke((Object)skeleton, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        } else if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            return phantom.shouldBurnInDay();
        }
        return false;
    }

    public static void setShouldBurnDuringTheDay(LivingEntity entity, boolean value) {
        if (!PaperLib.isPaper()) {
            return;
        }
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.setShouldBurnInDay(value);
        } else if (Constants.MINECRAFT_1_18_2 && entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            skeleton.setShouldBurnInDay(value);
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            try {
                Skeleton.class.getMethod("setShouldBurnInDay", Boolean.TYPE).invoke((Object)skeleton, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        } else if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            phantom.setShouldBurnInDay(value);
        }
    }

    public static boolean canCriticalDamage(Entity entity) {
        Player p;
        return entity instanceof Player && (p = (Player)entity).getFallDistance() > 0.0f && !entity.isOnGround() && !p.isClimbing() && !p.isInWater() && !p.hasPotionEffect(PotionEffectType.BLINDNESS) && !p.hasPotionEffect(PotionEffectType.SLOW_FALLING) && !p.isInsideVehicle() && (double)p.getAttackCooldown() > 0.9 && !p.isSprinting();
    }

    public static boolean isAngry(LivingEntity entity) {
        if (entity instanceof PigZombie) {
            PigZombie pigZombie = (PigZombie)entity;
            return pigZombie.isAngry();
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            return wolf.isAngry();
        }
        if (Constants.HAS_WARDEN && entity instanceof Warden) {
            Warden warden = (Warden)entity;
            return warden.getAngerLevel() == Warden.AngerLevel.ANGRY;
        }
        if (Constants.PAPER_1_18_2 && entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            return enderman.isScreaming();
        }
        return false;
    }

    public static boolean isInterested(LivingEntity entity) {
        if (Constants.PAPER_1_18_2 && entity instanceof Fox) {
            Fox fox = (Fox)entity;
            return fox.isInterested();
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            return wolf.isInterested();
        }
        return false;
    }

    public static void setIsInterested(LivingEntity entity, boolean interested) {
        if (Constants.PAPER_1_18_2 && entity instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.setInterested(interested);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setInterested(interested);
        }
    }

    public static void setIsAngry(LivingEntity entity, boolean bool) {
        if (entity instanceof PigZombie) {
            PigZombie pigZombie = (PigZombie)entity;
            pigZombie.setAngry(bool);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setAngry(bool);
        } else if (Constants.PAPER_1_18_2 && entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            enderman.setScreaming(bool);
        }
    }

    public static boolean isSitting(Entity entity) {
        if (entity instanceof Sittable) {
            Sittable sittable = (Sittable)entity;
            return sittable.isSitting();
        }
        return entity.getPose() == Pose.SITTING;
    }

    public static void setIsSitting(Entity entity, boolean sitting) {
        if (entity instanceof Sittable) {
            Sittable sittable = (Sittable)entity;
            sittable.setSitting(sitting);
        } else if (PaperLib.isPaper() && Constants.MINECRAFT_1_20_1) {
            if (sitting && entity.getPose() != Pose.SITTING) {
                entity.setPose(Pose.SITTING);
            } else if (entity.getPose() == Pose.SITTING) {
                entity.setPose(Pose.STANDING);
            }
        }
    }

    public static boolean isScreaming(LivingEntity entity) {
        if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            return goat.isScreaming();
        }
        if (Constants.PAPER_1_18_2 && entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            return enderman.isScreaming();
        }
        return false;
    }

    public static void setIsScreaming(LivingEntity entity, boolean screaming) {
        if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            goat.setScreaming(screaming);
        } else if (Constants.PAPER_1_18_2 && entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            enderman.setScreaming(screaming);
        }
    }

    public static boolean isRoaring(LivingEntity entity) {
        if (Constants.PAPER_1_19_2 && entity instanceof Ravager) {
            Ravager ravager = (Ravager)entity;
            return ravager.getRoarTicks() > 0;
        }
        if (entity instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)entity;
            return enderDragon.getPhase() == EnderDragon.Phase.ROAR_BEFORE_ATTACK;
        }
        return entity.getPose() == Pose.ROARING;
    }

    public static boolean isConverting(LivingEntity entity) {
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglinAbstract = (PiglinAbstract)entity;
            return piglinAbstract.isConverting();
        }
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            return skeleton.isConverting();
        }
        if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            return hoglin.isConverting();
        }
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            return zombie.isConverting();
        }
        return false;
    }

    public static boolean isDancing(LivingEntity entity) {
        if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            return parrot.isDancing();
        }
        if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            return piglin.isDancing();
        }
        if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            return allay.isDancing();
        }
        return false;
    }

    public static List<UUID> getArrayAsUUIDList(Object[] objects) {
        return Arrays.stream(objects).map(o -> {
            if (o instanceof Entity) {
                Entity entity = (Entity)o;
                return entity.getUniqueId();
            }
            if (o instanceof String) {
                String string = (String)o;
                return UUID.fromString(string);
            }
            if (o instanceof UUID) {
                UUID aUuid = (UUID)o;
                return aUuid;
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public static void setCowVariant(AbstractCow cow, Cow.Variant variant) {
        if (COW_CLASS.isAssignableFrom(cow.getClass())) {
            try {
                COW_SET_VARIANT_METHOD.invoke((Object)cow, variant);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Cow Variant couldn't be obtained, please report this.", e);
            }
        }
    }

    public static Cow.Variant getCowVariant(AbstractCow cow) {
        if (COW_CLASS.isAssignableFrom(cow.getClass())) {
            try {
                return (Cow.Variant)COW_GET_VARIANT_METHOD.invoke((Object)cow, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Cow Variant couldn't be obtained, please report this.", e);
            }
        }
        return null;
    }

    @Nullable
    public static Object getVariant(LivingEntity livingEntity) {
        if (Constants.HAS_AXOLOTL_VARIANT && livingEntity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)livingEntity;
            return axolotl.getVariant();
        }
        if (Constants.HAS_FROG_VARIANT && livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            return frog.getVariant();
        }
        if (livingEntity instanceof MushroomCow) {
            MushroomCow mushroomCow = (MushroomCow)livingEntity;
            return mushroomCow.getVariant();
        }
        if (livingEntity instanceof Parrot) {
            Parrot parrot = (Parrot)livingEntity;
            return parrot.getVariant();
        }
        if (livingEntity instanceof Llama) {
            Llama llama = (Llama)livingEntity;
            return llama.getColor();
        }
        if (livingEntity instanceof Fox) {
            Fox fox = (Fox)livingEntity;
            return fox.getFoxType();
        }
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            return cat.getCatType();
        }
        if (livingEntity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)livingEntity;
            return rabbit.getRabbitType();
        }
        if (livingEntity instanceof Panda) {
            Panda panda = (Panda)livingEntity;
            return panda.getMainGene();
        }
        if (livingEntity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)livingEntity;
            return tropicalFish.getPattern();
        }
        if (Constants.HAS_FROG_VARIANT && livingEntity instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            return wolf.getVariant();
        }
        if (Constants.HAS_SALMON_VARIANT && livingEntity instanceof Salmon) {
            Salmon salmon = (Salmon)livingEntity;
            return salmon.getVariant();
        }
        if (Constants.HAS_PIG_VARIANT && livingEntity instanceof Pig) {
            Pig pig = (Pig)livingEntity;
            return pig.getVariant();
        }
        if (Constants.HAS_COW_VARIANT && livingEntity instanceof AbstractCow) {
            AbstractCow abstractCow = (AbstractCow)livingEntity;
            return EntityUtils.getCowVariant(abstractCow);
        }
        if (Constants.HAS_CHICKEN_VARIANT && livingEntity instanceof Chicken) {
            Chicken chicken = (Chicken)livingEntity;
            return chicken.getVariant();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setVariant(LivingEntity livingEntity, Object unknownVariant) {
        if (livingEntity instanceof MushroomCow) {
            MushroomCow mushroomCow = (MushroomCow)livingEntity;
            if (unknownVariant instanceof MushroomCow.Variant) {
                MushroomCow.Variant variant = (MushroomCow.Variant)unknownVariant;
                mushroomCow.setVariant(variant);
                return;
            }
        }
        if (livingEntity instanceof Parrot) {
            Parrot parrot = (Parrot)livingEntity;
            if (unknownVariant instanceof Parrot.Variant) {
                Parrot.Variant variant = (Parrot.Variant)unknownVariant;
                parrot.setVariant(variant);
                return;
            }
        }
        if (livingEntity instanceof Llama) {
            Llama llama = (Llama)livingEntity;
            if (unknownVariant instanceof Llama.Color) {
                Llama.Color color = (Llama.Color)unknownVariant;
                llama.setColor(color);
                return;
            }
        }
        if (livingEntity instanceof Fox) {
            Fox fox = (Fox)livingEntity;
            if (unknownVariant instanceof Fox.Type) {
                Fox.Type type = (Fox.Type)unknownVariant;
                fox.setFoxType(type);
                return;
            }
        }
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            if (unknownVariant instanceof Cat.Type) {
                Cat.Type type = (Cat.Type)unknownVariant;
                cat.setCatType(type);
                return;
            }
        }
        if (livingEntity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)livingEntity;
            if (unknownVariant instanceof Rabbit.Type) {
                Rabbit.Type type = (Rabbit.Type)unknownVariant;
                rabbit.setRabbitType(type);
                return;
            }
        }
        if (livingEntity instanceof Panda) {
            Panda panda = (Panda)livingEntity;
            if (unknownVariant instanceof Panda.Gene) {
                Panda.Gene gene = (Panda.Gene)unknownVariant;
                panda.setMainGene(gene);
                return;
            }
        }
        if (livingEntity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)livingEntity;
            if (unknownVariant instanceof TropicalFish.Pattern) {
                TropicalFish.Pattern pattern = (TropicalFish.Pattern)unknownVariant;
                tropicalFish.setPattern(pattern);
                return;
            }
        }
        if (Constants.HAS_FROG_VARIANT && livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            if (unknownVariant instanceof Frog.Variant) {
                Frog.Variant variant = (Frog.Variant)unknownVariant;
                frog.setVariant(variant);
                return;
            }
        }
        if (Constants.HAS_WOLF_VARIANT && livingEntity instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            if (unknownVariant instanceof Wolf.Variant) {
                Wolf.Variant variant = (Wolf.Variant)unknownVariant;
                wolf.setVariant(variant);
                return;
            }
        }
        if (Constants.HAS_SALMON_VARIANT && livingEntity instanceof Salmon) {
            Salmon salmon = (Salmon)livingEntity;
            if (unknownVariant instanceof Salmon.Variant) {
                Salmon.Variant variant = (Salmon.Variant)unknownVariant;
                salmon.setVariant(variant);
                return;
            }
        }
        if (Constants.HAS_AXOLOTL_VARIANT && livingEntity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)livingEntity;
            if (unknownVariant instanceof Axolotl.Variant) {
                Axolotl.Variant variant = (Axolotl.Variant)unknownVariant;
                axolotl.setVariant(variant);
                return;
            }
        }
        if (Constants.HAS_CHICKEN_VARIANT && livingEntity instanceof Chicken) {
            Chicken chicken = (Chicken)livingEntity;
            if (unknownVariant instanceof Chicken.Variant) {
                Chicken.Variant variant = (Chicken.Variant)unknownVariant;
                chicken.setVariant(variant);
                return;
            }
        }
        if (Constants.HAS_COW_VARIANT && livingEntity instanceof AbstractCow) {
            AbstractCow abstractCow = (AbstractCow)livingEntity;
            if (unknownVariant instanceof Cow.Variant) {
                Cow.Variant variant = (Cow.Variant)unknownVariant;
                EntityUtils.setCowVariant(abstractCow, variant);
                return;
            }
        }
        if (!Constants.HAS_PIG_VARIANT) return;
        if (!(livingEntity instanceof Pig)) return;
        Pig pig = (Pig)livingEntity;
        if (!(unknownVariant instanceof Pig.Variant)) return;
        Pig.Variant variant = (Pig.Variant)unknownVariant;
        pig.setVariant(variant);
    }

    @Nullable
    public static ItemStack getEntityEquipmentSlot(LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        EntityEquipment entityEquipment;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player.getInventory().getItem(equipmentSlot);
        }
        if ((!Constants.PAPER_1_21 || livingEntity.canUseEquipmentSlot(equipmentSlot)) && (entityEquipment = livingEntity.getEquipment()) != null) {
            return entityEquipment.getItem(equipmentSlot);
        }
        return null;
    }

    public static void setEntityEquipmentSlot(LivingEntity livingEntity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        EntityEquipment entityEquipment;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getInventory().setItem(equipmentSlot, itemStack);
        } else if ((!Constants.PAPER_1_21 || livingEntity.canUseEquipmentSlot(equipmentSlot)) && (entityEquipment = livingEntity.getEquipment()) != null) {
            entityEquipment.setItem(equipmentSlot, itemStack);
        }
    }

    @Nullable
    public static EntityData<?> toEntityData(EntityType entityType) {
        return entityType == null ? null : ch.njol.skript.bukkitutil.EntityUtils.toSkriptEntityData((EntityType)entityType);
    }

    @Nullable
    public static EntityType toEntityType(EntityData<?> entityType) {
        return entityType == null ? null : ch.njol.skript.bukkitutil.EntityUtils.toBukkitEntityType(entityType);
    }

    static {
        if (Constants.HAS_COW_VARIANT) {
            try {
                COW_CLASS = Class.forName("org.bukkit.entity.Cow");
                COW_GET_VARIANT_METHOD = COW_CLASS.getDeclaredMethod("getVariant", new Class[0]);
                COW_SET_VARIANT_METHOD = COW_CLASS.getDeclaredMethod("setVariant", Cow.Variant.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException("Cow Variant couldn't be obtained, please report this.", e);
            }
        } else {
            COW_CLASS = null;
            COW_GET_VARIANT_METHOD = null;
            COW_SET_VARIANT_METHOD = null;
        }
    }
}

